package com.myorg;

import software.amazon.awscdk.lib.Construct;
import software.amazon.awscdk.lib.Duration;
import software.amazon.awscdk.lib.Stack;
import software.amazon.awscdk.lib.StackProps;
import software.amazon.awscdk.services.sns.Topic;
import software.amazon.awscdk.services.sns.subscriptions.SqsSubscription;
import software.amazon.awscdk.services.sqs.Queue;

public class %name.PascalCased%Stack extends Stack {
    public %name.PascalCased%Stack(final Construct parent, final String id) {
        this(parent, id, null);
    }

    public %name.PascalCased%Stack(final Construct parent, final String id, final StackProps props) {
        super(parent, id, props);

        final Queue queue = Queue.Builder.create(this, "%name.PascalCased%Queue")
                .visibilityTimeout(Duration.seconds(300))
                .build();

        final Topic topic = Topic.Builder.create(this, "%name.PascalCased%Topic")
            .displayName("My First Topic Yeah")
            .build();

        topic.addSubscription(new SqsSubscription(queue));
    }
}
